/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfResult;
import com.ibm.hwmca.fw.rbf.RbfResultProcessor;
import com.ibm.hwmca.fw.rbf.impl.QueryTask;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ResultReporter {
    private static final String TRACE_MASKT = "XRBFRRPT";
    private static final String TRACE_MASKF = "XRBFRRPF";
    private static final String TRACE_MASKD = "XRBFRRPD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-RsltRprt");
    private static LinkedList queue = new LinkedList();
    private static List reporters = new ArrayList();
    private static Object reportersLock = new Object();
    private static final int REPORTERS_MAX = 15;
    private static final long REPORTER_TIMEOUT = 120000L;
    private static final int QUEUE_BACKLOG_PER_THREAD = 0;

    private ResultReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reportAndClose(RbfRequest request, int statusCode, Object details) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> reportAndClose() " + requestId);
        RbfResult result = new RbfResult(request, statusCode, details);
        RequestTrackingData trackingData = request.getTrackingData();
        Object object = trackingData;
        synchronized (object) {
            trackingData.state = 16;
            trackingData.result = result;
            trackingData.addHistory("Reporting result status " + statusCode);
            QueryTask queryTask = trackingData.queryTask;
            if (queryTask != null) {
                queryTask.cancel();
                trackingData.queryTask = null;
            }
            try {
                RequestManager requestMgr = RequestManager.getRequestManager();
                requestMgr.changed(request);
            }
            catch (RbfException rbfe) {
                // empty catch block
            }
        }
        object = reportersLock;
        synchronized (object) {
            queue.add(request);
            Trace.trace(TRACE_MASKD, ResultReporter.getQueueDump());
            Trace.trace(TRACE_MASKF, queue.size() + " requests in the result " + "reporter queue");
            int active = reporters.size();
            if (active < 15 && queue.size() > 0 * active) {
                Reporter reporter = new Reporter(new Date().toString());
                reporter.start();
                reporters.add(reporter);
                Trace.trace(TRACE_MASKF, reporters.size() + " reporters in existence");
            }
            reportersLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- reportAndClose() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reportAndClose(RbfRequest request) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> reportAndClose() " + requestId);
        Object object = reportersLock;
        synchronized (object) {
            queue.add(request);
            Trace.trace(TRACE_MASKD, ResultReporter.getQueueDump());
            Trace.trace(TRACE_MASKF, queue.size() + " requests in the result " + "reporter queue");
            int active = reporters.size();
            if (active < 15 && queue.size() > 0 * active) {
                Reporter reporter = new Reporter(new Date().toString());
                reporter.start();
                reporters.add(reporter);
            }
            Trace.trace(TRACE_MASKF, reporters.size() + " reporter threads in existence");
            reportersLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- reportAndClose() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQueueDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Result reporter queue:\n");
        Object object = reportersLock;
        synchronized (object) {
            if (queue.isEmpty()) {
                sb.append("1. Empty");
            } else {
                int index = 1;
                Iterator iterator = queue.iterator();
                while (iterator.hasNext()) {
                    RbfRequest request = (RbfRequest)iterator.next();
                    if (index == 1) {
                        sb.append(index + ". " + request.getIdentifier());
                    } else {
                        sb.append("\n" + index + ". " + request.getIdentifier());
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    private static class Reporter
    extends Thread {
        String id;
        boolean inactive = false;
        RbfRequest nextRequest = null;

        Reporter(String id) {
            super("RBF Result Reporter " + id);
            this.id = id;
            Trace.trace(ResultReporter.TRACE_MASKT, "<> Reporter " + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: {
                try {
                    Trace.trace(ResultReporter.TRACE_MASKT, "-> Reporter " + this.id + " running");
                    while (!this.inactive) {
                        this.nextRequest = null;
                        long waitBegins = System.currentTimeMillis();
                        long timeToWait = 120000L;
                        Object object = reportersLock;
                        synchronized (object) {
                            while (queue.size() <= 0 && timeToWait > 0L) {
                                try {
                                    reportersLock.wait(timeToWait);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                timeToWait = 120000L - (System.currentTimeMillis() - waitBegins);
                            }
                            if (queue.size() > 0) {
                                this.nextRequest = (RbfRequest)queue.removeFirst();
                            } else {
                                reporters.remove(this);
                                this.inactive = true;
                            }
                        }
                        if (this.nextRequest == null) continue;
                        this.reportAndClose(this.nextRequest);
                    }
                    Trace.trace(ResultReporter.TRACE_MASKT, "<- Reporter " + this.id + " ending due to inactivity");
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    this.getThreadGroup().uncaughtException(this, throwable);
                    Object object = reportersLock;
                    synchronized (object) {
                        reporters.remove(this);
                    }
                    if (this.nextRequest == null || this.nextRequest.getState() == 20) break block15;
                    this.reportAndClose(this.nextRequest);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportAndClose(RbfRequest request) {
            Object desc;
            Class<?> procClass = null;
            RbfResultProcessor resultProcessor = null;
            RbfRequestId requestId = request.getIdentifier();
            RequestTrackingData trackingData = request.getTrackingData();
            if (trackingData.result != null) {
                FrameworkLog fl;
                String desc2;
                Trace.trace(ResultReporter.TRACE_MASKF, "Reporting: " + trackingData.result);
                try {
                    procClass = Class.forName(request.getResultProcessor());
                    resultProcessor = (RbfResultProcessor)procClass.newInstance();
                }
                catch (Exception e) {
                    desc2 = e.getClass().getName() + " creating a " + procClass.getName() + " instance " + requestId + ":\n" + RbfUtils.getStackTrace(e);
                    Trace.trace(ResultReporter.TRACE_MASKF, desc2);
                    fl = new FrameworkLog(classLogInfo, 1058);
                    fl.add(desc2);
                    fl.add(RbfUtils.getLoggingInfo(request));
                    fl.log();
                }
                if (procClass != null && resultProcessor != null) {
                    try {
                        String theCall = procClass.getName() + ".rbfResultAvailable() " + requestId;
                        Trace.trace(ResultReporter.TRACE_MASKF, "-> " + theCall);
                        resultProcessor.rbfResultAvailable(request, trackingData.result);
                        Trace.trace(ResultReporter.TRACE_MASKF, "<- " + theCall);
                    }
                    catch (Exception e) {
                        desc2 = "Uncaught exception from " + procClass.getName() + ".rbfResultAvailable() " + requestId + ":\n" + RbfUtils.getStackTrace(e);
                        Trace.trace(ResultReporter.TRACE_MASKF, desc2);
                        fl = new FrameworkLog(classLogInfo, 1059);
                        fl.add(desc2);
                        fl.add(RbfUtils.getLoggingInfo(request));
                        fl.log();
                    }
                }
            } else {
                desc = "Internal error: Corrupted tracking data: Result not available to be reported";
                Trace.trace(ResultReporter.TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
            }
            desc = trackingData;
            synchronized (desc) {
                trackingData.state = 20;
                trackingData.addHistory("Completed");
            }
            try {
                RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                RbfHandleResponse handleResponse = rhMgr.getHandleResponse(request.getIdentifier());
                if (handleResponse != null) {
                    rhMgr.removeHandleResponse(handleResponse);
                }
            }
            catch (RbfException rbfe) {
                // empty catch block
            }
            try {
                RequestManager requestMgr = RequestManager.getRequestManager();
                requestMgr.close(request);
            }
            catch (RbfException rbfe) {
                try {
                    RequestManager requestMgr = RequestManager.getRequestManager();
                    requestMgr.changed(request);
                }
                catch (RbfException rbfe2) {
                    // empty catch block
                }
            }
        }
    }
}

